# windows.mak

!include $(COMPONENTS_CACHE)\build-$(BUILD_VER)-$(CLASSIFIER)\$(CLASSIFIER)\shared.mak

LIBJPEG_TURBO_DIR = $(COMPONENTS_CACHE)\libjpeg_turbo-$(LIBJPEG_TURBO_VER)-$(CLASSIFIER)
LIBPNG_DIR = $(COMPONENTS_CACHE)\libpng-$(LIBPNG_VER)-$(CLASSIFIER)
OPENJPEG_DIR = $(COMPONENTS_CACHE)\openjpeg-$(OPENJPEG_VER)-$(CLASSIFIER)
SPTIFF_DIR = $(COMPONENTS_CACHE)\sptiff-static-$(SPTIFF_VER)-$(CLASSIFIER)
ZLIB_DIR = $(COMPONENTS_CACHE)\zlib-$(ZLIB_VER)-$(CLASSIFIER)
LIBWEBP_DIR = Source\LibWebP

LIBJPEG_TURBO_LIB = $(LIBJPEG_TURBO_DIR)\$(CLASSIFIER)\libjpeg-turbo.lib
LIBPNG_LIB = $(LIBPNG_DIR)\$(CLASSIFIER)\libpng.lib
OPENJPEG_LIB = $(OPENJPEG_DIR)\$(CLASSIFIER)\openjpeg.lib
SPTIFF_LIB = $(SPTIFF_DIR)\$(CLASSIFIER)\tiff.lib
ZLIB_LIB = $(ZLIB_DIR)\$(CLASSIFIER)\zlib.lib

OS_LIBS =
!if "$(OPSYS)"=="winrt"
OS_LIBS = WindowsApp.lib
!endif

LIBS = $(LIBJPEG_TURBO_LIB) $(LIBPNG_LIB) $(OPENJPEG_LIB) $(SPTIFF_LIB) \
	$(ZLIB_LIB) $(SP_LIBS) $(OS_LIBS)

# no longer needed
!if "$(COMPILER)" == "ms9"
EMBED_MANIFEST_DLL = embed_manifest_dll
!else
EMBED_MANIFEST_DLL = $(DO_NOTHING)
!endif

CFLAGS_FREEIMAGE = -D WIN32 -D _WINDOWS -D _USRDLL -D OPJ_STATIC \
	-D FREEIMAGE_EXPORTS -D _CRT_SECURE_NO_DEPRECATE -D LIBRAW_NODLL \
	-D NO_GETENV -D NO_PUTENV \
	-D FREEIMAGE_REV=\"$(FREEIMAGE_REV)\" \
	-D SPFREEIMAGE_VERSION=\"$(VERSION)\" \
	-I $(LIBJPEG_TURBO_DIR)\include \
	-I $(LIBPNG_DIR)\include \
	-I $(OPENJPEG_DIR)\include

CFLAGS = $(SP_CFLAGS_COMPILE) $(SP_CPPFLAGS_ADD) $(CFLAGS_FREEIMAGE)

COMPILE = $(SP_GPP) $(CFLAGS) -Fo$@ -c

O = $(PWD)

build: $(O)\dll$(STORE).flag

FREEIMAGE_OBJECTS = $(O)\Background.obj $(O)\BSplineRotate.obj \
	$(O)\Channels.obj $(O)\ClassicRotate.obj $(O)\Colors.obj \
	$(O)\CopyPaste.obj $(O)\Display.obj $(O)\Flip.obj \
	$(O)\JPEGTransform.obj $(O)\MultigridPoissonSolver.obj \
	$(O)\Rescale.obj $(O)\Resize.obj $(O)\BitmapAccess.obj \
	$(O)\CacheFile.obj $(O)\ColorLookup.obj $(O)\Conversion.obj \
	$(O)\Conversion16_555.obj $(O)\Conversion16_565.obj \
	$(O)\Conversion24.obj $(O)\Conversion32.obj \
	$(O)\Conversion4.obj $(O)\Conversion8.obj \
	$(O)\ConversionFloat.obj $(O)\ConversionRGB16.obj \
	$(O)\ConversionRGBA16.obj $(O)\ConversionRGBAF.obj \
	$(O)\ConversionRGBF.obj $(O)\ConversionType.obj \
	$(O)\ConversionUINT16.obj \
	$(O)\FreeImage.obj $(O)\FreeImageC.obj \
	$(O)\FreeImageIO.obj $(O)\GetType.obj $(O)\Halftoning.obj \
	$(O)\J2KHelper.obj $(O)\LFPQuantizer.obj $(O)\MemoryIO.obj \
	$(O)\MultiPage.obj \
	$(O)\NNQuantizer.obj $(O)\PixelAccess.obj $(O)\Plugin.obj \
	$(O)\PluginBMP.obj $(O)\PluginCUT.obj $(O)\PluginDDS.obj \
	$(O)\PluginEXR.obj $(O)\PluginG3.obj $(O)\PluginGIF.obj \
	$(O)\PluginHDR.obj $(O)\PluginICO.obj $(O)\PluginIFF.obj \
	$(O)\PluginJ2K.obj $(O)\PluginJP2.obj $(O)\PluginJPEG.obj \
	$(O)\PluginKOALA.obj $(O)\PluginPCD.obj \
	$(O)\PluginPCX.obj $(O)\PluginPFM.obj $(O)\PluginPICT.obj \
	$(O)\PluginPNG.obj $(O)\PluginPNM.obj $(O)\PluginPSD.obj \
	$(O)\PluginRAS.obj $(O)\PluginSGI.obj \
	$(O)\PluginTARGA.obj $(O)\PluginTIFF.obj $(O)\PluginWBMP.obj \
	$(O)\PluginWebP.obj \
	$(O)\PluginXBM.obj $(O)\PluginXPM.obj $(O)\PSDParser.obj \
	$(O)\TIFFLogLuv.obj $(O)\tmoColorConvert.obj $(O)\tmoDrago03.obj \
	$(O)\tmoFattal02.obj $(O)\tmoReinhard05.obj $(O)\ToneMapping.obj \
	$(O)\WuQuantizer.obj $(O)\ZLibInterface.obj $(O)\Exif.obj \
	$(O)\FIRational.obj $(O)\FreeImageTag.obj $(O)\IPTC.obj \
	$(O)\TagConversion.obj $(O)\TagLib.obj $(O)\XTIFF.obj

LIBWEBP_DEC_OBJECTS = $(O)\alpha_dec.obj $(O)\buffer_dec.obj \
	$(O)\frame_dec.obj $(O)\idec_dec.obj $(O)\io_dec.obj \
	$(O)\quant_dec.obj $(O)\tree_dec.obj \
	$(O)\vp8_dec.obj $(O)\vp8l_dec.obj $(O)\webp_dec.obj

LIBWEBP_DSP_OBJECTS = $(O)\alpha_processing.obj \
	$(O)\alpha_processing_mips_dsp_r2.obj $(O)\alpha_processing_neon.obj \
	$(O)\alpha_processing_sse2.obj $(O)\alpha_processing_sse41.obj \
	$(O)\cost.obj $(O)\cost_mips32.obj $(O)\cost_mips_dsp_r2.obj \
	$(O)\cost_neon.obj $(O)\cost_sse2.obj $(O)\cpu.obj $(O)\dec.obj \
	$(O)\dec_clip_tables.obj $(O)\dec_mips32.obj $(O)\dec_mips_dsp_r2.obj \
	$(O)\dec_msa.obj $(O)\dec_neon.obj $(O)\dec_sse2.obj \
	$(O)\dec_sse41.obj \
	$(O)\enc.obj $(O)\enc_mips32.obj $(O)\enc_mips_dsp_r2.obj \
	$(O)\enc_msa.obj $(O)\enc_neon.obj $(O)\enc_sse2.obj \
	$(O)\enc_sse41.obj $(O)\filters.obj $(O)\filters_mips_dsp_r2.obj \
	$(O)\filters_msa.obj $(O)\filters_neon.obj $(O)\filters_sse2.obj \
	$(O)\lossless.obj $(O)\lossless_avx2.obj \
	$(O)\lossless_enc.obj $(O)\lossless_enc_avx2.obj \
	$(O)\lossless_enc_mips32.obj \
	$(O)\lossless_enc_mips_dsp_r2.obj $(O)\lossless_enc_msa.obj \
	$(O)\lossless_enc_neon.obj $(O)\lossless_enc_sse2.obj \
	$(O)\lossless_enc_sse41.obj $(O)\lossless_mips_dsp_r2.obj \
	$(O)\lossless_msa.obj $(O)\lossless_neon.obj \
	$(O)\lossless_sse2.obj $(O)\lossless_sse41.obj \
	$(O)\rescaler.obj $(O)\rescaler_mips32.obj \
	$(O)\rescaler_mips_dsp_r2.obj $(O)\rescaler_msa.obj \
	$(O)\rescaler_neon.obj $(O)\rescaler_sse2.obj \
	$(O)\ssim.obj $(O)\ssim_sse2.obj $(O)\upsampling.obj \
	$(O)\upsampling_mips_dsp_r2.obj $(O)\upsampling_msa.obj \
	$(O)\upsampling_neon.obj $(O)\upsampling_sse2.obj \
	$(O)\upsampling_sse41.obj $(O)\yuv.obj \
	$(O)\yuv_mips32.obj $(O)\yuv_mips_dsp_r2.obj $(O)\yuv_neon.obj \
	$(O)\yuv_sse2.obj $(O)\yuv_sse41.obj

LIBWEBP_ENC_OBJECTS = $(O)\alpha_enc.obj $(O)\analysis_enc.obj \
	$(O)\backward_references_cost_enc.obj \
	$(O)\backward_references_enc.obj \
	$(O)\config_enc.obj $(O)\cost_enc.obj $(O)\filter_enc.obj \
	$(O)\frame_enc.obj $(O)\histogram_enc.obj $(O)\iterator_enc.obj \
	$(O)\near_lossless_enc.obj $(O)\picture_csp_enc.obj \
	$(O)\picture_enc.obj $(O)\picture_psnr_enc.obj \
	$(O)\picture_rescale_enc.obj $(O)\picture_tools_enc.obj \
	$(O)\predictor_enc.obj $(O)\quant_enc.obj $(O)\syntax_enc.obj \
	$(O)\token_enc.obj $(O)\tree_enc.obj $(O)\vp8l_enc.obj \
	$(O)\webp_enc.obj

LIBWEBP_MUX_OBJECTS = $(O)\anim_encode.obj $(O)\muxedit.obj \
	$(O)\muxinternal.obj $(O)\muxread.obj

LIBWEBP_SHARPYUV_OBJECTS = $(O)\sharpyuv.obj $(O)\sharpyuv_cpu.obj \
	$(O)\sharpyuv_csp.obj $(O)\sharpyuv_dsp.obj \
	$(O)\sharpyuv_gamma.obj $(O)\sharpyuv_neon.obj \
	$(O)\sharpyuv_sse2.obj

LIBWEBP_UTILS_OBJECTS = $(O)\bit_reader_utils.obj $(O)\bit_writer_utils.obj \
	$(O)\color_cache_utils.obj $(O)\filters_utils.obj \
	$(O)\huffman_encode_utils.obj $(O)\huffman_utils.obj \
	$(O)\palette.obj $(O)\quant_levels_dec_utils.obj \
	$(O)\quant_levels_utils.obj $(O)\random_utils.obj \
	$(O)\rescaler_utils.obj $(O)\thread_utils.obj \
	$(O)\utils.obj

LIBWEBP_OBJECTS = $(LIBWEBP_DEC_OBJECTS) $(LIBWEBP_DSP_OBJECTS) \
	$(LIBWEBP_ENC_OBJECTS) $(LIBWEBP_MUX_OBJECTS) \
	$(LIBWEBP_SHARPYUV_OBJECTS) $(LIBWEBP_UTILS_OBJECTS)

OBJECTS = $(FREEIMAGE_OBJECTS) $(LIBWEBP_OBJECTS)

.SUFFIXES: .obj .c .cpp

{source\FreeImage}.c{$(O)}.obj:
	$(COMPILE) -I Source -I Source\FreeImageToolkit -I Source\Metadata $<

{source\FreeImage}.cpp{$(O)}.obj:
	$(COMPILE) -I Source -I Source\FreeImageToolkit -I Source\Metadata \
		-I $(ZLIB_DIR)\include $<

{source\FreeImageToolkit}.cpp{$(O)}.obj:
	$(COMPILE) -I Source -I Source\FreeImageToolkit -I Source\Metadata $<

{source\Metadata}.cpp{$(O)}.obj:
	$(COMPILE) -I Source -I Source\FreeImageToolkit -I Source\Metadata $<

{source\LibWebP\sharpyuv}.c{$(O)}.obj:
	$(COMPILE) -I Source\LibWebP $<

{source\LibWebP\src\dec}.c{$(O)}.obj:
	$(COMPILE) -I Source\LibWebP $<

{source\LibWebP\src\dsp}.c{$(O)}.obj:
	$(COMPILE) -I Source\LibWebP $<

{source\LibWebP\src\enc}.c{$(O)}.obj:
	$(COMPILE) -I Source\LibWebP $<

{source\LibWebP\src\mux}.c{$(O)}.obj:
	$(COMPILE) -I Source\LibWebP $<

{source\LibWebP\src\utils}.c{$(O)}.obj:
	$(COMPILE) -I Source\LibWebP $<

# Don't bother with dependencies on header files

$(O)\dll$(STORE).flag: $(OBJECTS)
!if "$(STORE)"==""
	$(SP_LINK_DLL) -Fe$(O)\SPFreeImage_1.dll $(OBJECTS) $(LIBS) $(SP_LINK_TAIL)
	$(EMBED_MANIFEST_DLL) $(O)\SPFreeImage_1.dll
	$(SP_SIGN) $(O)\SPFreeImage_1.dll
!else
	$(SP_LINK_DLL) -Fe$(O)\SPFreeImage_1_app.dll $(OBJECTS) $(LIBS) $(SP_LINK_TAIL) /appcontainer
	$(EMBED_MANIFEST_DLL) $(O)\SPFreeImage_1_app.dll
	$(SP_SIGN) $(O)\SPFreeImage_1_app.dll
!endif
	echo done >$(O)\dll$(STORE).flag

T = $(OBJ_DIR)/tmp
WT = $(OBJ_DIR_WINDOWS)\tmp
Z = $(OBJ_DIR)/spfreeimage-$(VERSION)-$(CLASSIFIER).zip

package:
	rm -rf "$(T)"
	rm -f "$(Z)"
	mkdir "$(T)"
	mkdir "$(T)"/$(CLASSIFIER)
	mkdir "$(T)"/include
	create_versions build.sh "$(T)"/versions.txt
	cp $(O)/SPFreeImage_1.dll "$(T)"/$(CLASSIFIER)/
	cp $(O)/SPFreeImage_1.pdb "$(T)"/$(CLASSIFIER)/
	cp $(O)/SPFreeImage_1.lib "$(T)"/$(CLASSIFIER)/
!if "$(OPSYS)" == "winrt"
	cp $(O)/SPFreeImage_1_app.dll "$(T)"/$(CLASSIFIER)/
	cp $(O)/SPFreeImage_1_app.pdb "$(T)"/$(CLASSIFIER)/
	cp $(O)/SPFreeImage_1_app.lib "$(T)"/$(CLASSIFIER)/
!endif
	cp Source/FreeImage.h "$(T)"/include
	cp license-fi.txt "$(T)"/License-FreeImage.txt
	cp $(LIBJPEG_TURBO_DIR)/License*.txt "$(T)"/
	cp $(LIBPNG_DIR)/License*.txt "$(T)"/
	cp $(OPENJPEG_DIR)/License*.txt "$(T)"/
	cp $(SPTIFF_DIR)/License*.txt "$(T)"/
	cp $(ZLIB_DIR)/License*.txt "$(T)"/
	cp $(LIBWEBP_DIR)/COPYING "$(T)"/License-libwebp.txt
	cp ../License-where_to_get_source_code.txt "$(T)"/License-where_to_get_source_code.txt
	cp ../SPFreeImage.rel "$(T)"/
	pushd "$(WT)" && zip -$(ZIP_LEVEL)rp "$(Z)" . && popd
	cp $(Z) $(COMPONENTS_CACHE)/out/
