/* SPTiffRuntime.h */

#ifndef SPTIFFRUNTIME_H__
#define SPTIFFRUNTIME_H__

#ifdef __cplusplus
extern "C" {
#endif

#define SPTIFF_SYMBOL_VERSIONS
#if defined (WIN32)
#define SPTIFF_LINK __cdecl
#else
#define SPTIFF_LINK
#endif

#include <stdarg.h>
#include <tiffio.h>

// tiff/tiffio.h
typedef void (SPTIFF_LINK *FP__TIFFfree)(void *);
typedef void * (SPTIFF_LINK *FP__TIFFmalloc)(tmsize_t);
typedef void * (SPTIFF_LINK *FP__TIFFcalloc)(tmsize_t, tmsize_t);
typedef int (SPTIFF_LINK *FP__TIFFmemcmp)(const void *, const void *, tmsize_t);
typedef void (SPTIFF_LINK *FP__TIFFmemcpy)(void *, const void *, tmsize_t);
typedef void (SPTIFF_LINK *FP__TIFFmemset)(void *, int, tmsize_t);
typedef void * (SPTIFF_LINK *FP__TIFFrealloc)(void *, tmsize_t);
typedef int (SPTIFF_LINK *FP_TIFFGetTagListCount)(TIFF *);
typedef uint32_t (SPTIFF_LINK *FP_TIFFGetTagListEntry)(TIFF *, int);
typedef int (SPTIFF_LINK *FP_TIFFCheckTile)(TIFF *, uint32_t, uint32_t, uint32_t, uint16_t);
typedef TIFF * (SPTIFF_LINK *FP_TIFFClientOpen)(const char *, const char *, thandle_t, TIFFReadWriteProc, TIFFReadWriteProc, TIFFSeekProc, TIFFCloseProc, TIFFSizeProc, TIFFMapFileProc, TIFFUnmapFileProc);
typedef const char * (SPTIFF_LINK *FP_TIFFFileName)(TIFF *);
typedef const char * (SPTIFF_LINK *FP_TIFFSetFileName)(TIFF *, const char *);
typedef void (SPTIFF_LINK *FP_TIFFError)(const char*, const char*, ...);
typedef void (SPTIFF_LINK *FP_TIFFErrorExt)(thandle_t, const char *, const char *, ...);
typedef void (SPTIFF_LINK *FP_TIFFWarning)(const char *, const char *, ...);
typedef void (SPTIFF_LINK *FP_TIFFWarningExt)(thandle_t, const char *, const char *, ...);
typedef void (SPTIFF_LINK *FP_TIFFClose)(TIFF *);
typedef uint32_t (SPTIFF_LINK *FP_TIFFComputeStrip)(TIFF *, uint32_t, uint16_t);
typedef uint32_t (SPTIFF_LINK *FP_TIFFComputeTile)(TIFF *, uint32_t, uint32_t, uint32_t, uint16_t);
typedef tdir_t (SPTIFF_LINK *FP_TIFFCurrentDirectory)(TIFF *);
typedef uint64_t (SPTIFF_LINK *FP_TIFFCurrentDirOffset)(TIFF *);
typedef uint32_t (SPTIFF_LINK *FP_TIFFCurrentRow)(TIFF *);
typedef uint32_t (SPTIFF_LINK *FP_TIFFCurrentStrip)(TIFF *);
typedef uint32_t (SPTIFF_LINK *FP_TIFFCurrentTile)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFReadBufferSetup)(TIFF *, void *, tmsize_t);
typedef int (SPTIFF_LINK *FP_TIFFWriteBufferSetup)(TIFF *, void *, tmsize_t);  
typedef int (SPTIFF_LINK *FP_TIFFDataWidth)(TIFFDataType);
typedef void (SPTIFF_LINK *FP_TIFFSetWriteOffset)(TIFF *, toff_t);
typedef void (SPTIFF_LINK *FP_TIFFSwabShort)(uint16_t*);
typedef void (SPTIFF_LINK *FP_TIFFSwabLong)(uint32_t*);
typedef void (SPTIFF_LINK *FP_TIFFSwabLong8)(uint64_t*);
typedef void (SPTIFF_LINK *FP_TIFFSwabFloat)(float*);
typedef void (SPTIFF_LINK *FP_TIFFSwabDouble)(double*);
typedef void (SPTIFF_LINK *FP_TIFFSwabArrayOfShort)(uint16_t* wp, tmsize_t n);
typedef void (SPTIFF_LINK *FP_TIFFSwabArrayOfTriples)(uint8_t* tp, tmsize_t n);
typedef void (SPTIFF_LINK *FP_TIFFSwabArrayOfLong)(uint32_t* lp, tmsize_t n);
typedef void (SPTIFF_LINK *FP_TIFFSwabArrayOfLong8)(uint64_t* lp, tmsize_t n);
typedef void (SPTIFF_LINK *FP_TIFFSwabArrayOfFloat)(float* fp, tmsize_t n);
typedef void (SPTIFF_LINK *FP_TIFFSwabArrayOfDouble)(double* dp, tmsize_t n);
typedef void (SPTIFF_LINK *FP_TIFFReverseBits)(uint8_t* cp, tmsize_t n);
typedef const unsigned char * (SPTIFF_LINK *FP_TIFFGetBitRevTable)(int);
typedef uint32_t (SPTIFF_LINK *FP_TIFFDefaultStripSize)(TIFF *, uint32_t);
typedef void (SPTIFF_LINK *FP_TIFFDefaultTileSize)(TIFF *, uint32_t *, uint32_t *);
typedef uint32_t (SPTIFF_LINK *FP_TIFFFieldTag)(const TIFFField *);
typedef const char * (SPTIFF_LINK *FP_TIFFFieldName)(const TIFFField *);
typedef TIFFDataType (SPTIFF_LINK *FP_TIFFFieldDataType)(const TIFFField *);
typedef int (SPTIFF_LINK *FP_TIFFFieldPassCount)(const TIFFField *);
typedef int (SPTIFF_LINK *FP_TIFFFieldReadCount)(const TIFFField *);
typedef int (SPTIFF_LINK *FP_TIFFFieldWriteCount)(const TIFFField *);
typedef TIFFTagMethods *(SPTIFF_LINK *FP_TIFFAccessTagMethods)(TIFF *);
typedef void * (SPTIFF_LINK *FP_TIFFGetClientInfo)(TIFF *, const char *);
typedef void (SPTIFF_LINK *FP_TIFFSetClientInfo)(TIFF *, void *, const char *);
typedef void (SPTIFF_LINK *FP_TIFFCleanup)(TIFF *);
typedef const TIFFField * (SPTIFF_LINK *FP_TIFFFieldWithName)(TIFF *, const char *);
typedef const TIFFField * (SPTIFF_LINK *FP_TIFFFieldWithTag)(TIFF *, uint32_t);
typedef int (SPTIFF_LINK *FP_TIFFFileno)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFSetFileno)(TIFF *, int);
typedef thandle_t (SPTIFF_LINK *FP_TIFFClientdata)(TIFF *);
typedef thandle_t (SPTIFF_LINK *FP_TIFFSetClientdata)(TIFF *, thandle_t);
typedef int (SPTIFF_LINK *FP_TIFFGetMode)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFSetMode)(TIFF *, int);
typedef const TIFFField * (SPTIFF_LINK *FP_TIFFFindField)(TIFF *, uint32_t, TIFFDataType);
typedef int (SPTIFF_LINK *FP_TIFFFlush)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFFlushData)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFGetField)(TIFF *, uint32_t, ...);
typedef int (SPTIFF_LINK *FP_TIFFVGetField)(TIFF *, uint32_t, va_list);
typedef int (SPTIFF_LINK *FP_TIFFGetFieldDefaulted)(TIFF*, uint32_t, ...);
typedef int (SPTIFF_LINK *FP_TIFFVGetFieldDefaulted)(TIFF*, uint32_t, va_list);
typedef const char * (SPTIFF_LINK *FP_TIFFGetVersion)(void);
typedef int (SPTIFF_LINK *FP_TIFFIsBigEndian)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFIsByteSwapped)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFIsMSB2LSB)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFIsTiled)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFIsUpSampled)(TIFF *);
typedef TIFFReadWriteProc (SPTIFF_LINK *FP_TIFFGetReadProc)(TIFF *);
typedef TIFFReadWriteProc (SPTIFF_LINK *FP_TIFFGetWriteProc)(TIFF *);
typedef TIFFSeekProc (SPTIFF_LINK *FP_TIFFGetSeekProc)(TIFF *);
typedef TIFFCloseProc (SPTIFF_LINK *FP_TIFFGetCloseProc)(TIFF *);
typedef TIFFSizeProc (SPTIFF_LINK *FP_TIFFGetSizeProc)(TIFF *);
typedef TIFFMapFileProc (SPTIFF_LINK *FP_TIFFGetMapFileProc)(TIFF *);
typedef TIFFUnmapFileProc (SPTIFF_LINK *FP_TIFFGetUnmapFileProc)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFLastDirectory)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFMergeFieldInfo)(TIFF *, const TIFFFieldInfo[], uint32_t);
typedef tdir_t (SPTIFF_LINK *FP_TIFFNumberOfDirectories)(TIFF *);
typedef uint32_t (SPTIFF_LINK *FP_TIFFNumberOfStrips)(TIFF *);
typedef uint32_t (SPTIFF_LINK *FP_TIFFNumberOfTiles)(TIFF *);
typedef TIFF * (SPTIFF_LINK *FP_TIFFOpen)(const char *, const char *);
#if 0
typedef TIFF * (SPTIFF_LINK *FP_TIFFOpenW)(const wchar_t *, const char *);
#endif
typedef TIFF * (SPTIFF_LINK *FP_TIFFFdOpen)(int, const char *, const char *);
typedef void (SPTIFF_LINK *FP_TIFFPrintDirectory)(TIFF *, FILE *, long);
typedef uint64_t (SPTIFF_LINK *FP_TIFFRasterScanlineSize64)(TIFF *);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFRasterScanlineSize)(TIFF *);
typedef uint64_t (SPTIFF_LINK *FP_TIFFRawStripSize64)(TIFF *, uint32_t);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFRawStripSize)(TIFF *, uint32_t);
typedef int (SPTIFF_LINK *FP_TIFFReadDirectory)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFReadCustomDirectory)(TIFF *, toff_t, const TIFFFieldArray *);
typedef int (SPTIFF_LINK *FP_TIFFReadEXIFDirectory)(TIFF *, toff_t);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFReadEncodedStrip)(TIFF *, uint32_t, void *, tmsize_t);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFReadEncodedTile)(TIFF *, uint32_t, void *, tmsize_t);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFReadRawStrip)(TIFF *, uint32_t, void *, tmsize_t);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFReadRawTile)(TIFF *, uint32_t, void *, tmsize_t);
typedef int (SPTIFF_LINK *FP_TIFFReadRGBAImage)(TIFF *, uint32_t, uint32_t, uint32_t *, int);
typedef int (SPTIFF_LINK *FP_TIFFReadRGBAImageOriented)(TIFF *, uint32_t, uint32_t, uint32_t *, int, int);
typedef int (SPTIFF_LINK *FP_TIFFReadRGBAStrip)(TIFF *, uint32_t, uint32_t *);
typedef int (SPTIFF_LINK *FP_TIFFReadRGBATile)(TIFF *, uint32_t, uint32_t, uint32_t *);
typedef int (SPTIFF_LINK *FP_TIFFReadRGBAStripExt)(TIFF *, uint32_t, uint32_t *, int);
typedef int (SPTIFF_LINK *FP_TIFFReadRGBATileExt)(TIFF *, uint32_t, uint32_t, uint32_t *, int);
typedef int (SPTIFF_LINK *FP_TIFFReadScanline)(TIFF *, void *, uint32_t, uint16_t);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFReadTile)(TIFF *, void *, uint32_t, uint32_t, uint32_t, uint16_t);
typedef int (SPTIFF_LINK *FP_TIFFRewriteDirectory)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFRGBAImageBegin)(TIFFRGBAImage *, TIFF *, int, char[1024]);
typedef void (SPTIFF_LINK *FP_TIFFRGBAImageEnd)(TIFFRGBAImage *);
typedef int (SPTIFF_LINK *FP_TIFFRGBAImageGet)(TIFFRGBAImage *, uint32_t *, uint32_t, uint32_t);
typedef int (SPTIFF_LINK *FP_TIFFRGBAImageOK)(TIFF *, char[1024]);
typedef uint64_t (SPTIFF_LINK *FP_TIFFScanlineSize64)(TIFF *);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFScanlineSize)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFSetDirectory)(TIFF *, tdir_t);
typedef TIFFErrorHandler (SPTIFF_LINK *FP_TIFFSetErrorHandler)(TIFFErrorHandler);
typedef TIFFErrorHandlerExt (SPTIFF_LINK *FP_TIFFSetErrorHandlerExt)(TIFFErrorHandlerExt);
typedef int (SPTIFF_LINK *FP_TIFFSetField)(TIFF *, uint32_t, ...);
typedef int (SPTIFF_LINK *FP_TIFFVSetField)(TIFF *, uint32_t, va_list);
typedef int (SPTIFF_LINK *FP_TIFFSetSubDirectory)(TIFF *, uint64_t);
typedef int (SPTIFF_LINK *FP_TIFFUnsetField)(TIFF *, uint32_t);
typedef int (SPTIFF_LINK *FP_TIFFUnlinkDirectory)(TIFF*, tdir_t);
typedef TIFFExtendProc (SPTIFF_LINK *FP_TIFFSetTagExtender)(TIFFExtendProc);
typedef int (SPTIFF_LINK *FP_TIFFSetupStrips)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFWriteCheck)(TIFF *, int, const char *);
typedef void (SPTIFF_LINK *FP_TIFFFreeDirectory)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFCreateDirectory)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFCreateCustomDirectory)(TIFF *, const TIFFFieldArray *);
typedef int (SPTIFF_LINK *FP_TIFFCreateEXIFDirectory)(TIFF *);
typedef TIFFErrorHandler (SPTIFF_LINK *FP_TIFFSetWarningHandler)(TIFFErrorHandler);
typedef TIFFErrorHandlerExt (SPTIFF_LINK *FP_TIFFSetWarningHandlerExt)(TIFFErrorHandlerExt);
typedef uint64_t (SPTIFF_LINK *FP_TIFFStripSize64)(TIFF *);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFStripSize)(TIFF *);
typedef uint64_t (SPTIFF_LINK *FP_TIFFTileRowSize64)(TIFF *);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFTileRowSize)(TIFF *);
typedef uint64_t (SPTIFF_LINK *FP_TIFFTileSize64)(TIFF *);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFTileSize)(TIFF *);
typedef uint64_t (SPTIFF_LINK *FP_TIFFVStripSize64)(TIFF *, uint32_t);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFVStripSize)(TIFF *, uint32_t);
typedef uint64_t (SPTIFF_LINK *FP_TIFFVTileSize64)(TIFF *, uint32_t);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFVTileSize)(TIFF *, uint32_t);
typedef int (SPTIFF_LINK *FP_TIFFWriteDirectory)(TIFF *);
typedef int (SPTIFF_LINK *FP_TIFFWriteCustomDirectory)(TIFF *, uint64_t *);
typedef int (SPTIFF_LINK *FP_TIFFCheckpointDirectory)(TIFF *);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFWriteEncodedStrip)(TIFF *, uint32_t, void *, tmsize_t);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFWriteEncodedTile)(TIFF *, uint32_t, void *, tmsize_t);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFWriteRawStrip)(TIFF *, uint32_t, void *, tmsize_t);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFWriteRawTile)(TIFF *, uint32_t, void *, tmsize_t);
typedef int (SPTIFF_LINK *FP_TIFFWriteScanline)(TIFF *, void *, uint32_t, uint16_t);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFWriteTile)(TIFF *, void *, uint32_t, uint32_t, uint32_t, uint16_t);
typedef int (SPTIFF_LINK *FP_TIFFCIELabToRGBInit)(TIFFCIELabToRGB *, const TIFFDisplay *, float*);
typedef void (SPTIFF_LINK *FP_TIFFCIELabToXYZ)(TIFFCIELabToRGB *, uint32_t, int32_t, int32_t, float *, float *, float *);
typedef void (SPTIFF_LINK *FP_TIFFXYZToRGB)(TIFFCIELabToRGB *, float, float, float, uint32_t *, uint32_t *, uint32_t *);
typedef int (SPTIFF_LINK *FP_TIFFYCbCrToRGBInit)(TIFFYCbCrToRGB *, float *, float *);
typedef void (SPTIFF_LINK *FP_TIFFYCbCrtoRGB)(TIFFYCbCrToRGB *, uint32_t, int32_t, int32_t, uint32_t *, uint32_t *, uint32_t *);
typedef TIFF * (SPTIFF_LINK *FP_TIFFMemOpen)(const char *, const char *, uint8_t *, tmsize_t size);
typedef tmsize_t (SPTIFF_LINK *FP_TIFFMemSize)(TIFF *);
typedef void (SPTIFF_LINK *FP_TIFFMemCopy)(TIFF *, uint8_t *);
typedef TIFFOpenOptions * (SPTIFF_LINK *FP_TIFFOpenOptionsAlloc)(void);
typedef void (SPTIFF_LINK *FP_TIFFOpenOptionsFree)(TIFFOpenOptions *);
typedef void (SPTIFF_LINK *FP_TIFFOpenOptionsSetMaxSingleMemAlloc)(TIFFOpenOptions *, tmsize_t);
typedef void (SPTIFF_LINK *FP_TIFFOpenOptionsSetErrorHandlerExtR)(TIFFOpenOptions *, TIFFErrorHandlerExtR, void *);
typedef void (SPTIFF_LINK *FP_TIFFOpenOptionsSetWarningHandlerExtR)(TIFFOpenOptions *, TIFFErrorHandlerExtR, void *);
typedef TIFF * (SPTIFF_LINK *FP_TIFFOpenExt)(const char *, const char *, TIFFOpenOptions *);
#if 0
typedef TIFF * (SPTIFF_LINK *FP_TIFFOpenWExt)(const wchar_t *, const char *, TIFFOpenOptions *);
#endif
typedef TIFF * (SPTIFF_LINK *FP_TIFFFdOpenExt)(int, const char *, const char *, TIFFOpenOptions *);
typedef TIFF * (SPTIFF_LINK *FP_TIFFClientOpenExt)(const char *, const char *, thandle_t, TIFFReadWriteProc, TIFFReadWriteProc, TIFFSeekProc, TIFFCloseProc, TIFFSizeProc, TIFFMapFileProc, TIFFUnmapFileProc, TIFFOpenOptions *);
typedef TIFF * (SPTIFF_LINK *FP_TIFFMemOpenExt)(const char *, const char *, uint8_t *, tmsize_t, TIFFOpenOptions *);

// tiff/tiffiop.h
typedef float (SPTIFF_LINK *FP__TIFFClampDoubleToFloat)(double);
typedef uint32_t (SPTIFF_LINK *FP__TIFFClampDoubleToUInt32)(double);

typedef void (SPTIFF_LINK *FP__TIFFremoved)(void);

#define SPTIFF_FUNCTIONS(F,R) \
  F (TIFFAccessTagMethods) \
  F (TIFFCIELabToRGBInit) \
  F (TIFFCIELabToXYZ) \
  F (TIFFCheckTile) \
  F (TIFFCheckpointDirectory) \
  F (TIFFCleanup) \
  F (TIFFClientOpen) \
  R (TIFFClientOpen2) \
  F (TIFFClientdata) \
  F (TIFFClose) \
  F (TIFFComputeStrip) \
  F (TIFFComputeTile) \
  F (TIFFCreateCustomDirectory) \
  F (TIFFCreateDirectory) \
  F (TIFFCreateEXIFDirectory) \
  F (TIFFCurrentDirOffset) \
  F (TIFFCurrentDirectory) \
  F (TIFFCurrentRow) \
  F (TIFFCurrentStrip) \
  F (TIFFCurrentTile) \
  F (TIFFDataWidth) \
  F (TIFFDefaultStripSize) \
  F (TIFFDefaultTileSize) \
  R (TIFFDestroyApplication) \
  F (TIFFError) \
  F (TIFFErrorExt) \
  R (TIFFErrorExt2) \
  F (TIFFFdOpen) \
  R (TIFFFdOpen2) \
  F (TIFFFieldDataType) \
  F (TIFFFieldName) \
  F (TIFFFieldPassCount) \
  F (TIFFFieldReadCount) \
  F (TIFFFieldTag) \
  F (TIFFFieldWithName) \
  F (TIFFFieldWithTag) \
  F (TIFFFieldWriteCount) \
  F (TIFFFileName) \
  F (TIFFFileno) \
  R (TIFFFindCODEC2) \
  F (TIFFFindField) \
  F (TIFFFlush) \
  F (TIFFFlushData) \
  F (TIFFFreeDirectory) \
  R (TIFFGetApplication) \
  F (TIFFGetBitRevTable) \
  F (TIFFGetClientInfo) \
  F (TIFFGetCloseProc) \
  R (TIFFGetConfiguredCODECs2) \
  F (TIFFGetField) \
  F (TIFFGetFieldDefaulted) \
  F (TIFFGetMapFileProc) \
  F (TIFFGetMode) \
  F (TIFFGetReadProc) \
  F (TIFFGetSeekProc) \
  F (TIFFGetSizeProc) \
  F (TIFFGetTagListCount) \
  F (TIFFGetTagListEntry) \
  F (TIFFGetUnmapFileProc) \
  F (TIFFGetVersion) \
  F (TIFFGetWriteProc) \
  F (TIFFIsBigEndian) \
  F (TIFFIsByteSwapped) \
  R (TIFFIsCODECConfigured2) \
  F (TIFFIsMSB2LSB) \
  F (TIFFIsTiled) \
  F (TIFFIsUpSampled) \
  F (TIFFLastDirectory) \
  F (TIFFMemCopy) \
  F (TIFFMemOpen) \
  R (TIFFMemOpen2) \
  F (TIFFMemSize) \
  F (TIFFMergeFieldInfo) \
  R (TIFFNewApplication) \
  F (TIFFNumberOfDirectories) \
  F (TIFFNumberOfStrips) \
  F (TIFFNumberOfTiles) \
  F (TIFFOpen) \
  R (TIFFOpen2) \
  F (TIFFPrintDirectory) \
  F (TIFFRGBAImageBegin) \
  F (TIFFRGBAImageEnd) \
  F (TIFFRGBAImageGet) \
  F (TIFFRGBAImageOK) \
  F (TIFFRasterScanlineSize) \
  F (TIFFRasterScanlineSize64) \
  F (TIFFRawStripSize) \
  F (TIFFRawStripSize64) \
  F (TIFFReadBufferSetup) \
  F (TIFFReadCustomDirectory) \
  F (TIFFReadDirectory) \
  F (TIFFReadEXIFDirectory) \
  F (TIFFReadEncodedStrip) \
  F (TIFFReadEncodedTile) \
  F (TIFFReadRGBAImage) \
  F (TIFFReadRGBAImageOriented) \
  F (TIFFReadRGBAStrip) \
  F (TIFFReadRGBAStripExt) \
  F (TIFFReadRGBATile) \
  F (TIFFReadRGBATileExt) \
  F (TIFFReadRawStrip) \
  F (TIFFReadRawTile) \
  F (TIFFReadScanline) \
  F (TIFFReadTile) \
  R (TIFFRegisterCODEC2) \
  F (TIFFReverseBits) \
  F (TIFFRewriteDirectory) \
  F (TIFFScanlineSize) \
  F (TIFFScanlineSize64) \
  F (TIFFSetClientInfo) \
  F (TIFFSetClientdata) \
  F (TIFFSetDirectory) \
  F (TIFFSetErrorHandler) \
  R (TIFFSetErrorHandler2) \
  F (TIFFSetErrorHandlerExt) \
  R (TIFFSetErrorHandlerExt2) \
  F (TIFFSetField) \
  F (TIFFSetFileName) \
  F (TIFFSetFileno) \
  F (TIFFSetMode) \
  F (TIFFSetSubDirectory) \
  F (TIFFSetTagExtender) \
  R (TIFFSetTagExtender2) \
  F (TIFFSetWarningHandler) \
  R (TIFFSetWarningHandler2) \
  F (TIFFSetWarningHandlerExt) \
  R (TIFFSetWarningHandlerExt2) \
  F (TIFFSetWriteOffset) \
  F (TIFFSetupStrips) \
  F (TIFFStripSize) \
  F (TIFFStripSize64) \
  F (TIFFSwabArrayOfDouble) \
  F (TIFFSwabArrayOfFloat) \
  F (TIFFSwabArrayOfLong) \
  F (TIFFSwabArrayOfLong8) \
  F (TIFFSwabArrayOfShort) \
  F (TIFFSwabArrayOfTriples) \
  F (TIFFSwabDouble) \
  F (TIFFSwabFloat) \
  F (TIFFSwabLong) \
  F (TIFFSwabLong8) \
  F (TIFFSwabShort) \
  F (TIFFTileRowSize) \
  F (TIFFTileRowSize64) \
  F (TIFFTileSize) \
  F (TIFFTileSize64) \
  R (TIFFUnRegisterCODEC2) \
  F (TIFFUnlinkDirectory) \
  F (TIFFUnsetField) \
  F (TIFFVGetField) \
  F (TIFFVGetFieldDefaulted) \
  F (TIFFVSetField) \
  F (TIFFVStripSize) \
  F (TIFFVStripSize64) \
  F (TIFFVTileSize) \
  F (TIFFVTileSize64) \
  F (TIFFWarning) \
  F (TIFFWarningExt) \
  R (TIFFWarningExt2) \
  F (TIFFWriteBufferSetup) \
  F (TIFFWriteCheck) \
  F (TIFFWriteCustomDirectory) \
  F (TIFFWriteDirectory) \
  F (TIFFWriteEncodedStrip) \
  F (TIFFWriteEncodedTile) \
  F (TIFFWriteRawStrip) \
  F (TIFFWriteRawTile) \
  F (TIFFWriteScanline) \
  F (TIFFWriteTile) \
  F (TIFFXYZToRGB) \
  F (TIFFYCbCrToRGBInit) \
  F (TIFFYCbCrtoRGB) \
  F (_TIFFcalloc) \
  F (_TIFFfree) \
  F (_TIFFmalloc) \
  F (_TIFFmemcmp) \
  F (_TIFFmemcpy) \
  F (_TIFFmemset) \
  F (_TIFFrealloc) \
  F (_TIFFClampDoubleToFloat) \
  F (_TIFFClampDoubleToUInt32) \
  F (TIFFOpenOptionsAlloc) \
  F (TIFFOpenOptionsFree) \
  F (TIFFOpenOptionsSetMaxSingleMemAlloc) \
  F (TIFFOpenOptionsSetErrorHandlerExtR) \
  F (TIFFOpenOptionsSetWarningHandlerExtR) \
  F (TIFFOpenExt) \
  F (TIFFFdOpenExt) \
  F (TIFFClientOpenExt) \
  F (TIFFMemOpenExt)

#define DEF(x) FP_##x x;
#define REMOVED(x) FP__TIFFremoved x##_removed;

/**
 * @brief Table of function pointers for SPTiff.
 */
struct SPTiff
{
  /**
   * @brief Non-zero iff SPTiffInit() was successful.
   *
   * SPTiffInit() sets this member to a non-zero value if succesful,
   * to zero on error.
   */
  int mOK;

  /**
   * @brief The consuming code may put some pointer here.
   *
   * SPTiffInit() sets this member to NULL.
   */
  void *mData;

  /**
   * @brief The function pointers.
   */
  SPTIFF_FUNCTIONS (DEF, REMOVED)
};

#undef DEF
#undef REMOVED

/**
 * @brief Load SPTiff DLL at runtime (libtiff functions).
 *
 * This function is not thread-safe, even if called with diferent
 * objects passed for @a aTable by different threads.
 *
 * Errors are reported by LPRINTF1.
 *
 * @param aTable [o]  Table of function pointers that will be filled by
 *                    this function.
 * @param aSize [i]   Size of the table pointed to by @a aTable.
 * @return -1 on error, 0 if successful.
 */
int SPTIFF_LINK SPTiffInit (struct SPTiff *aTable, size_t aSize);

#ifdef __cplusplus
}
#endif

#endif /* SPTIFFRUNTIME_H__ */
